<?php
require "../db_connect.php";

if (!isset($_SESSION['user_id']) || !isset($_SESSION['round'])) {
    exit(json_encode(["status" => "error", "message" => "Unauthorized access"]));
}

$user = $_SESSION['user_id'];
$round = intval($_SESSION['round']);
$lastQuestion = $_SESSION['no_of_questions']; // Define the total number of questions

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $quizData = isset($_SESSION['quiz_answers']) ? $_SESSION['quiz_answers'] : [];

    // Step 1: Save current session answers to the database
    $conn->begin_transaction();
    try {
        $stmt = $conn->prepare("INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE user_answer = VALUES(user_answer)");
        if (!$stmt) {
            throw new Exception("SQL Error: " . $conn->error);
        }

        foreach ($quizData as $questionNumber => $answer) {
            $stmt->bind_param("siii", $user, $round, $questionNumber, $answer);
            if (!$stmt->execute()) {
                throw new Exception("Execution failed: " . $stmt->error);
            }
        }

        $stmt->close();
        $conn->commit();
    } catch (Exception $e) {
        $conn->rollback();
        error_log("Transaction Failed: " . $e->getMessage());
        echo json_encode(["status" => "error", "message" => "Data submission failed."]);
        exit;
    }

    // Step 2: Get all saved answers from the database
    $existingAnswers = [];
    $stmt = $conn->prepare("SELECT question_number, user_answer FROM user_answer WHERE user_id = ? AND round_id = ?");
    $stmt->bind_param("si", $user, $round);
    $stmt->execute();
    $result = $stmt->get_result();

    while ($row = $result->fetch_assoc()) {
        $existingAnswers[$row['question_number']] = intval($row['user_answer']);
    }
    $stmt->close();

    // Step 3: Fill in missing answers with 0
    for ($i = 1; $i <= $lastQuestion; $i++) {
        if (!isset($existingAnswers[$i])) {
            $existingAnswers[$i] = 0; // Set unanswered questions to 0
        }
    }

    // Step 4: Save updated answers back into database
    $conn->begin_transaction();
    try {
        $stmt = $conn->prepare("INSERT INTO user_answer (user_id, round_id, question_number, user_answer) VALUES (?, ?, ?, ?) ON DUPLICATE KEY UPDATE user_answer = VALUES(user_answer)");
        if (!$stmt) {
            throw new Exception("SQL Error: " . $conn->error);
        }

        foreach ($existingAnswers as $questionNumber => $answer) {
            $stmt->bind_param("siii", $user, $round, $questionNumber, $answer);
            if (!$stmt->execute()) {
                throw new Exception("Execution failed: " . $stmt->error);
            }
        }

        $stmt->close();
        $conn->commit();
    } catch (Exception $e) {
        $conn->rollback();
        error_log("Transaction Failed: " . $e->getMessage());
        echo json_encode(["status" => "error", "message" => "Final answer logging failed."]);
        exit;
    }

    // Step 5: Clear session and restart quiz from 0
    unset($_SESSION['quiz_answers']);
    echo json_encode(["status" => "success", "message" => "Timeout handled. Answers saved.", "restart" => true]);
}
?>
