<?php
header('Content-Type: application/json');
require '../db_connect.php';

$limit = $_SESSION['no_of_questions']?? 50;
// if (!isset($_SESSION['round'])) {
//     echo json_encode(['error' => 'Session round ID is missing.']);
//     exit; // Stop further execution
// }

$round = $_SESSION['round']?? 1;
mysqli_set_charset($conn, "utf8mb4"); // Set correct encoding

$query = "SELECT id, question_number, question_text, code_snippet, option_1, option_2, option_3, option_4 
          FROM questions WHERE round_id = '$round' ORDER BY RAND() LIMIT $limit";

$result = $conn->query($query);

$questions = [];
$index = 1;
if ($result->num_rows > 0) {
    while ($row = $result->fetch_assoc()) {
        foreach ($row as &$value) {
            if (!mb_check_encoding($value, 'UTF-8')) {
                $value = utf8_encode($value);
            }
        }
        $questions[] = [
            'counter' => $index,
            'id' => $row['id'],
            'question_number' => intval($row['question_number']),
            'question_text' => $row['question_text'],
            'code_snippet' => $row['code_snippet'], 
            'options' => [
                $row['option_1'],
                $row['option_2'],
                $row['option_3'],
                $row['option_4']
            ]
        ];
        $index++;
    }
     echo json_encode(['questions' => $questions], JSON_UNESCAPED_UNICODE);
} else {
     echo json_encode(['error' => 'No questions found.'], JSON_UNESCAPED_UNICODE);
}

$conn->close();
?>
