<?php
require "../db_connect.php";


// Check if data is sent via POST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    error_log("Received Data: " . print_r($_POST, true)); // Debugging log
    $questionNumber = isset($_POST['questionNumber']) ? intval($_POST['questionNumber']) : null;
    $answer = isset($_POST['answer']) ? $_POST['answer'] : null;

    if ($questionNumber !== null && $answer !== null) {
        // Store the answer in session
        $_SESSION['quiz_answers'][$questionNumber] = $answer;

        // Return success response
        echo json_encode(["status" => "success", "message" => "Answer saved successfully.", "data" => $_SESSION['quiz_answers']]);
    } else {
        // Return error response
        echo json_encode(["status" => "error", "message" => "Invalid input data."]);
    }
} else {
    // Return session data if requested
    echo json_encode(isset($_SESSION['quiz_answers']) ? $_SESSION['quiz_answers'] : []);
}
