<?php
require '../db_connect.php';
header("Content-Type: application/json");

// Check if user is logged in
if (!isset($_SESSION['user_id']) || !isset($_SESSION['password'])) {
    echo json_encode(["status" => "logout"]);
    exit();
}

$user_id = $_SESSION['user_id'];
$storedPassword = $_SESSION['password']; // Password stored in session

// Fetch the latest password from the database
$sql = "SELECT password FROM users WHERE user_id = ?";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $user_id);
$stmt->execute();
$stmt->bind_result($dbPassword);
$stmt->fetch();
$stmt->close();

// Check if the password has changed
if ($storedPassword !== $dbPassword) {
    session_destroy();
    echo json_encode(["status" => "logout"]);
    echo "<script> localStorage.clear();</script>";
   // msgAlert('Logout Successfully','home/');
    exit();
}

// If password is the same, return success
echo json_encode(["status" => "ok"]);
?>
