document.addEventListener("DOMContentLoaded", () => {
    const elem = document.documentElement;

    // Function to enter fullscreen
    function requestFullScreen() {
        if (!document.fullscreenElement) {
            if (elem.requestFullscreen) {
                elem.requestFullscreen();
            } else if (elem.mozRequestFullScreen) { // Firefox
                elem.mozRequestFullScreen();
            } else if (elem.webkitRequestFullscreen) { // Chrome, Safari, Opera
                elem.webkitRequestFullscreen();
            } else if (elem.msRequestFullscreen) { // IE/Edge
                elem.msRequestFullscreen();
            }
        }
    }

    // Ask the user to click to enable fullscreen
    document.addEventListener("click", goFullScreen, { once: false });

    // Function to log violations
    function logViolation(message) {
        console.log("Violation Detected:", message);
        
        // Send to server (optional)
        fetch("log_violation.php", {
            method: "POST",
            headers: { "Content-Type": "application/json" },
            body: JSON.stringify({ violation: message, timestamp: new Date().toISOString() })
        }).catch(err => console.error("Error logging violation:", err));
    }

    // Detect window minimize or tab switch
    document.addEventListener("visibilitychange", () => {
        if (document.visibilityState === "hidden") {
            logViolation("User minimized window or switched tabs");
        }
    });

    // Detect exit from fullscreen
    document.addEventListener("fullscreenchange", () => {
        if (!document.fullscreenElement) {
            logViolation("User exited fullscreen mode");
            setTimeout(requestFullScreen, 1000); // Try to re-enter fullscreen
        }
    });

    // Detect Escape key press
    document.addEventListener("keydown", (event) => {
        if (event.key === "Escape") {
            logViolation("User pressed Escape to exit fullscreen");
            setTimeout(requestFullScreen, 1000);
        }
    });

    // Enter fullscreen on page load
    setTimeout(requestFullScreen, 500);
});
