<?php
require "../db_connect.php";

$uploadDir = __DIR__ . '/uploads/';
if (!file_exists($uploadDir) && !mkdir($uploadDir, 0777, true)) {
    die(json_encode(["status" => "error", "message" => "Failed to create upload directory."]));
}

if (isset($_POST['image'])) {
    $imageData = base64_decode($_POST['image']);
    
    if ($imageData === false) {
        die(json_encode(["status" => "error", "message" => "Invalid image data."]));
    }

    $fileName = uniqid() . '.png';
    $filePath = $uploadDir . $fileName;
    $examtaker = "K112"; // Consider dynamically retrieving this

    if (file_put_contents($filePath, $imageData)) {
        $stmt = $conn->prepare("
            INSERT INTO user_photo (user_id, photo_path) 
            VALUES (?, ?) 
            ON DUPLICATE KEY UPDATE photo_path = VALUES(photo_path)
        ");
        $stmt->bind_param("ss", $examtaker, $fileName);

        if ($stmt->execute()) {
            echo json_encode(["status" => "success", "message" => "Photo uploaded and saved!", "file" => $fileName]);
        } else {
            echo json_encode(["status" => "error", "message" => "Database error: " . $conn->error]);
        }

        $stmt->close();
        $conn->close();
    } else {
        echo json_encode(["status" => "error", "message" => "Failed to save the image."]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "No image received."]);
}
?>
