<?php
session_start();
if(isset($_SESSION['user_id'])){
    header('Location: gettingstarted.php');
    exit();
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Exam Login</title>
    <link rel="shortcut icon" type="image/x-icon" href="../images/favicon.png" />
    <style>
        body {
            font-family: Arial, sans-serif;
            /* background: url('../images/taxclub_header2.png') no-repeat center center/cover; */
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100vh;
            margin: 0;
        }
        .login-container {
            background: white;
            padding: 20px;
            box-shadow: 10px 4px 10px rgba(0, 115, 135, 0.3);
            border-radius: 10px;
            text-align: center;
            width: 350px;
            height: 300px;
        }
        .login-container h2 {
            margin-bottom: 15px;
        }
        input {
            width: 90%;
            padding: 10px;
            margin: 10px 0;
            border: 1px solid #ccc;
            border-radius: 5px;
        }
        button {
            width: 95%;
            height: 3rem;
            padding: 10px;
            margin: 20px 10px 0 0;
            background-color: #165b29;
            color: white;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            float: right;
        }
        button:hover {
            background-color: #0f431e;
        }
        #error-msg{
            display: flex;
            padding: 10px;
            margin: 10px;
            height: 10px;
            /* border: 2px solid red; */
            justify-content: center;
            color:red;
        }

        /* Loading overlay */
        #loadingOverlay {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: rgba(0, 0, 0, 0.5);
            display: flex;
            align-items: center;
            justify-content: center;
            z-index: 9999;
        }
        .loading-container {
            background: white;
            padding: 20px;
            border-radius: 10px;
            text-align: center;
            height: fit-content;

            box-shadow: 0px 0px 10px rgba(0, 0, 0, 0.3);
        }
        .spinner {
            width: 40px;
            height: 40px;
            border: 4px solid rgba(0, 0, 0, 0.1);
            border-top: 4px solid #3498db;
            border-radius: 50%;
            animation: spin 1s linear infinite;
            margin: 10px auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        #login-container{
            display:block;
        }
        #mobile-warning {
          display: none;
          text-align: center;
          padding: 50px;
          font-family: Arial, sans-serif;
          font-size: 1.2em;
          color: #d21f3c;
          background-color: #f9f9f9;
        }
    </style>
    <script src="../js/jquery.js"></script>
</head>
<body>
    <div id="mobile-warning">
        🚫 This app is only accessible on a PC or desktop browser.
    </div>
    <div class="login-container" id="login-container">
        <img src="../images/taxclub_header2.png" alt="Logo" width="100">
        <p>Please login to your account.</p>
        <form id="loginForm">
            <label>UserID</label>
            <input type="text" id="username" placeholder="Enter user ID">
            <label>Passcode</label>
            <input type="password" id="password" placeholder="Enter Password">
            <button type="submit">Login</button>
            <p id="error-msg"></p>
        </form>
    </div>

    
    <script>
        $(document).ready(function() {
            $('#loginForm').submit(function(e) {
                e.preventDefault();
                var username = $('#username').val().trim();
                var password = $('#password').val().trim();

                if (username === '' || password === '') {
                    showError('Please fill in all fields');
                    return;
                }

                showLoading(); // Show loading overlay before request

                $.post('login.php', {username: username, password: password}, function(response) {
                    hideLoading(); // Hide loading overlay after request
                    if(response === 'inactive'){
                        showError('User Deactivated');
                    }else if (response === 'success') {
                        localStorage.clear();
                        window.location.href = 'gettingstarted.php';
                    }else if (response === 'success-admin'){
                        window.location.href = '../admin';
                    }else {
                        showError('Invalid credentials');
                    }
                }).fail(function() {
                    hideLoading();
                    showError('Error connecting to server');
                });
            });

            // Function to show error message and hide it after a few seconds
            function showError(message) {
                $('#error-msg').text(message).show();
                setTimeout(function() {
                    $('#error-msg').fadeOut();
                }, 1000); // Hides after 3 seconds
            }

            // Function to show loading overlay
            function showLoading() {
                let overlay = document.createElement("div");
                overlay.id = "loadingOverlay";
                overlay.innerHTML = `
                    <div class="loading-container">
                        <div class="spinner"></div>
                        <p>Logging in...</p>
                    </div>
                `;
                document.body.appendChild(overlay);
            }

            // Function to hide loading overlay
            function hideLoading() {
                let overlay = document.getElementById("loadingOverlay");
                if (overlay) {
                    overlay.remove();
                }
            }
        });
        // Simple mobile detection
        if (/Mobi|Android|iPhone|iPad|iPod|BlackBerry|IEMobile|Opera Mini/i.test(navigator.userAgent)) {
        document.getElementById('login-container').style.display = 'none';
        document.getElementById('mobile-warning').style.display = 'block';
        }
    </script>
</body>
</html>
