<?php
require "../db_connect.php";

// Fetch unique rounds
$roundQuery = "SELECT DISTINCT round_id FROM user_scores ORDER BY round_id ASC";
$roundResult = $conn->query($roundQuery);

$rounds = [];
while ($row = $roundResult->fetch_assoc()) {
    $rounds[] = $row['round_id'];
}

// Fetch distinct districts
$districts = [];
$districtQuery = "SELECT id, name FROM districts ORDER BY id ASC";
$districtResult = $conn->query($districtQuery);
while ($row = $districtResult->fetch_assoc()) {
    $districts[$row['id']] = $row['name'];
}

// Handle filter
$selectedDistrict = $_GET['district_id'] ?? 'all';

$sql = "SELECT t1.user_id uid, t1.round_id rid, t1.total totalquestion, 
t1.score_percentage score, t2.school_name school, t3.id district_id, t3.name district_name 
        FROM user_scores t1
        LEFT JOIN users t2 ON t2.user_id = t1.user_id
        LEFT JOIN districts t3 ON t3.id = t2.district";

if ($selectedDistrict !== 'all') {
    $sql .= " WHERE t3.id = '" . $conn->real_escape_string($selectedDistrict) . "'";
}

$sql .= " ORDER BY t1.user_id, t1.round_id";

$result = $conn->query($sql);

$scores = [];
$schools = [];
$districtNames = [];
while ($row = $result->fetch_assoc()) {
    $schools[$row['uid']] = $row['school'];
    $districtNames[$row['uid']] = $row['district_name'];
    $scores[$row['uid']][$row['rid']] = [
        'total' => $row['totalquestion'],
        'school' => $row['school'],
        'district' => $row['district_name'],
        'percentage' => $row['score']
    ];
}

// Download Excel
if (isset($_GET['download'])) {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=quiz_results.xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    $output = fopen("php://output", "w");

    $header = array_merge(["S/N", "User ID", "District", "School/Candidate's Name"], array_map(fn($r) => "Round $r - %", $rounds));
    fputcsv($output, $header, "\t");

    $counter = 1;
    foreach ($scores as $user_id => $roundScores) {
        $row = [$counter++, $user_id];
        $row[] = $districtNames[$user_id] ?? '-';
        $row[] = $schools[$user_id] ?? '-';
        foreach ($rounds as $round) {
            $row[] = $roundScores[$round]['percentage'] ?? '-';
        }
        fputcsv($output, $row, "\t");
    }

    fclose($output);
    exit;
}

$conn->close();
?>

<!-- <!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Quiz Results</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; }
        table { width: 90%; margin: 20px auto; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 10px; text-align: center; }
        th { background-color: #f2f2f2; }
        .download-btn { margin-top: 20px; padding: 10px 20px; background: green; color: white; border: none; cursor: pointer; }
        form { margin-bottom: 20px; }
    </style>
</head> -->
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Questions - Quiz Admin</title>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="css/styles.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 30vh;
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
            padding: 5px;
            /* margin-left:  20px; */
        }
        th {
            background: #f9f9f9;
        }

        .headertop {
            display: flex;
            flex-direction: row;
            background: #fff;
            padding: 20px;
            /* margin-left: 20px; */
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 600px;
            margin: 20px auto;
        }

        

       

        .btn {
            background: #007bff;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }

        .btn:hover {
            background: #0056b3;
        }

        .link-primary {
            display: inline-block;
            margin-top: 10px;
            text-decoration: none;
            color: #007bff;
            font-weight: bold;
        }

        .link-primary:hover {
            text-decoration: underline;
        }
        /* Highlight correct answers */
        .correct {
            background-color: #28a745;
            color: white;
            font-weight: bold;
        }
        /* body { font-family: Arial, sans-serif; text-align: center; } */
        table { width: 90%; margin: 20px auto; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 10px; text-align: center; }
        th { background-color: #f2f2f2; }
        .download-btn { margin-top: 20px; padding: 10px 20px; background: green; color: white; border: none; cursor: pointer; }
        form { margin-bottom: 20px; margin: 10px auto;}
        /* .download-btn { margin-top: 20px;align-items: center; padding: 10px 20px; background: green; color: white; border: none; cursor: pointer; } */
    </style>
</head>
<body>
    <nav>
        <ul>
        <li><a href="index.php">Dashboard</a></li>
            <li><a href="questions.php">Manage Questions</a></li>
            <li><a href="exams.php">Manage Exams</a></li>
            <li><a href="users.php">Manage Users</a></li>
            <li><a href="results.php">Results</a></li>
            <li><a href="merge.php" target="_blank">Videos</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </nav>
    <div class="headertop">
        <h2>Quiz Results</h2>

        <form method="GET">
            <label for="district">Select District:</label>
            <select name="district_id" id="district" required>
                <option value="all" <?= (!isset($_GET['district_id']) || $_GET['district_id'] == 'all') ? 'selected' : '' ?>>All Districts</option>
                <?php foreach ($districts as $id => $name): ?>
                    <option value="<?= htmlspecialchars($id) ?>" <?= (isset($_GET['district_id']) && $_GET['district_id'] == $id) ? 'selected' : '' ?>>
                        <?= htmlspecialchars($name) ?>
                    </option>
                <?php endforeach; ?>
            </select>
            <button type="submit">View</button>
            <button type="submit" name="download" value="1">Download Excel</button>
        </form>
    </div>

    <table>
        <tr>
            <th>S/N</th>
            <th>User ID</th>
            <th>District</th>
            <th>School/Candidate's Name</th>
            <?php foreach ($rounds as $round): ?>
                <th>Round <?= $round ?> - %</th>
            <?php endforeach; ?>
        </tr>
        <?php $i = 1; foreach ($scores as $user_id => $roundScores): ?>
        <tr>
            <td><?= $i++ ?></td>
            <td><?= $user_id ?></td>
            <td><?= $districtNames[$user_id] ?? '-' ?></td>
            <td><?= $schools[$user_id] ?? '-' ?></td>
            <?php foreach ($rounds as $round): ?>
                <td><?= $roundScores[$round]['percentage'] ?? '-' ?></td>
            <?php endforeach; ?>
        </tr>
        <?php endforeach; ?>
    </table>

</body>
</html>