<?php
require "../db_connect.php";

// Get unique rounds
$roundQuery = "SELECT DISTINCT round_id FROM user_scores ORDER BY round_id ASC";
$roundResult = $conn->query($roundQuery);

$rounds = [];
while ($row = $roundResult->fetch_assoc()) {
    $rounds[] = $row['round_id'];
}

// Fetch all user scores
$sql = "SELECT t1.user_id user_id, t1.round_id round_id, total, score_percentage, school_name FROM user_scores t1
        LEFT JOIN users t2 ON t2.user_id = t1.user_id
        ORDER BY t1.user_id, t1.round_id";
$result = $conn->query($sql);

$scores = [];
$schools = [];
while ($row = $result->fetch_assoc()) {
    $schools[$row['user_id']] = $row['school_name']; // Store school name
    $scores[$row['user_id']][$row['round_id']] = [
        'total' => $row['total'],
        'school' => $row['school_name'],
        'percentage' => $row['score_percentage']
    ];
}

$conn->close();

// If download is requested
if (isset($_GET['download'])) {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=quiz_results.xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    $output = fopen("php://output", "w");

    // Header row
    $header = array_merge(["S/N","User ID","School/Candidate's Name"], array_map(fn($r) => "Round $r - %", $rounds));
    fputcsv($output, $header, "\t");

    $counter = 1;
    // User data rows
    foreach ($scores as $user_id => $roundScores) {
        $row= [$counter++];
        $row[] = $user_id;
        $row[] = $schools[$user_id] ?? '-';
        foreach ($rounds as $round) {
            // $row[] = $roundScores[$round]['school'] ?? '-';
            $row[] = $roundScores[$round]['percentage'] ?? '-';
        }
        fputcsv($output, $row, "\t");
    }

    fclose($output);
    exit;
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Quiz Results</title>
    <style>
        body { font-family: Arial, sans-serif; text-align: center; }
        table { width: 90%; margin: 20px auto; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 10px; text-align: center; }
        th { background-color: #f2f2f2; }
        .download-btn { margin-top: 20px; padding: 10px 20px; background: green; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>

    <h2>Quiz Results</h2>
    <table>
        <tr>
            <th>S/N</th>
            <th>User ID</th>
            <th> Candidate/School's Name</th>
            <?php foreach ($rounds as $round): ?>
                
                <th>Round <?php echo $round; ?> - %</th>
            <?php endforeach; ?>
        </tr>
        
        <?php $i =1; foreach ($scores as $user_id => $roundScores): ?>
        <tr>
            <td><?php echo $i++; ?></td>
            <td><?php echo $user_id; ?></td>
            
            <td><?php echo $schools[$user_id] ?? '-'; ?></td>
            <!-- <td><?php echo $roundScores[$round]['school'] ?? '-'; ?></td> -->
            <?php foreach ($rounds as $round): ?>
                
                <td><?php echo $roundScores[$round]['percentage'] ?? '-'; ?></td>
            <?php endforeach; ?>
        </tr>
        <?php endforeach; ?>
    </table>

    <form method="GET">
        <button type="submit" name="download" class="download-btn">Download Excel</button>
    </form>

</body>
</html>
