<?php
include('../../db_connect.php');

if (!isset($_POST['user_id'])) {
    echo json_encode(["status" => "error", "message" => "User ID required."]);
    exit();
}

$user_id = $_POST['user_id']; // Convert to integer for safety
$query = "SELECT * FROM users WHERE user_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("s", $user_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["status" => "success", "data" => $row]);
} else {
    echo json_encode(["status" => "error", "message" => "User not found."]);
}

$stmt->close();
$conn->close();
?>
