<?php
include('../../db_connect.php');

if (!isset($_POST['round_id'])) {
    echo json_encode(["status" => "error", "message" => "Round ID required."]);
    exit();
}

$round_id = intval($_POST['round_id']);

$query = "SELECT COUNT(*) AS total FROM questions WHERE round_id = ?";
$stmt = $conn->prepare($query);
$stmt->bind_param("i", $round_id);
$stmt->execute();
$result = $stmt->get_result();

if ($row = $result->fetch_assoc()) {
    echo json_encode(["status" => "success", "total" => $row['total']]);
} else {
    echo json_encode(["status" => "error", "message" => "No questions found."]);
}

$stmt->close();
$conn->close();
?>
