<?php
require "../db_connect.php";

function getUserOrSchoolName($id){
    global $conn;
    $sql = "SELECT * FROM `users` WHERE `user_id` = '$id'";
    $exec = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($exec);
    return empty($row['fullnames'])? $row['school_name']:$row['fullnames'];
}

// Get unique rounds
$roundQuery = "SELECT DISTINCT round_id FROM user_scores ORDER BY round_id ASC";
$roundResult = $conn->query($roundQuery);

$rounds = [];
while ($row = $roundResult->fetch_assoc()) {
    $rounds[] = $row['round_id'];
}

// Fetch all user scores
$sql = "SELECT t1.user_id user_id, t1.round_id round_id, total, score_percentage, school_name FROM user_scores t1
        LEFT JOIN users t2 ON t2.user_id = t1.user_id
        ORDER BY t1.user_id, t1.round_id";
$result = $conn->query($sql);

$scores = [];
$schools = [];
while ($row = $result->fetch_assoc()) {
    $schools[$row['user_id']] =  getUserOrSchoolName($row['user_id']);  //$row['school_name']; // Store school name
    $scores[$row['user_id']][$row['round_id']] = [
        'total' => $row['total'],
        'school' => $row['school_name'],
        'percentage' => $row['score_percentage']
    ];
}

$conn->close();

// If download is requested
if (isset($_GET['download'])) {
    header("Content-Type: application/vnd.ms-excel");
    header("Content-Disposition: attachment; filename=quiz_results.xls");
    header("Pragma: no-cache");
    header("Expires: 0");

    $output = fopen("php://output", "w");

    // Header row
    $header = array_merge(["S/N","User ID","School/Candidate's Name"], array_map(fn($r) => "Round $r - %", $rounds));
    fputcsv($output, $header, "\t");

    $counter = 1;
    // User data rows
    foreach ($scores as $user_id => $roundScores) {
        $row= [$counter++];
        $row[] = $user_id;
        $row[] = $schools[$user_id] ?? '-';
        foreach ($rounds as $round) {
            // $row[] = $roundScores[$round]['school'] ?? '-';
            $row[] = $roundScores[$round]['percentage'] ?? '-';
        }
        fputcsv($output, $row, "\t");
    }

    fclose($output);
    exit;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Questions - Quiz Admin</title>
    <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script>
    <link rel="stylesheet" href="css/styles.css">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <style>
        .body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 30vh;
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
            padding: 5px;
            /* margin-left:  20px; */
        }
        th {
            background: #f9f9f9;
        }

        .upload-container {
            display: flex;
            flex-direction: row;
            background: #fff;
            padding: 20px;
            margin-left: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 350px;
        }

        .upload-container input[type="file"] {
            width: 90%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 10px;
        }

        .filter-container {
            margin-bottom: 20px;
            text-align: left;
        }

        .filter-container select {
            padding: 8px;
            font-size: 16px;
        }

        .btn {
            background: #007bff;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }

        .btn:hover {
            background: #0056b3;
        }

        .link-primary {
            display: inline-block;
            margin-top: 10px;
            text-decoration: none;
            color: #007bff;
            font-weight: bold;
        }

        .link-primary:hover {
            text-decoration: underline;
        }
        /* Highlight correct answers */
        .correct {
            background-color: #28a745;
            color: white;
            font-weight: bold;
        }
        /* body { font-family: Arial, sans-serif; text-align: center; } */
        table { width: 90%; margin: 20px auto; border-collapse: collapse; }
        th, td { border: 1px solid black; padding: 10px; text-align: center; }
        th { background-color: #f2f2f2; }
        .download-btn { margin-top: 20px;align-items: center; padding: 10px 20px; background: green; color: white; border: none; cursor: pointer; }
    </style>
</head>
<body>
    <nav>
        <ul>
        <li><a href="index.php">Dashboard</a></li>
            <li><a href="questions.php">Manage Questions</a></li>
            <li><a href="exams.php">Manage Exams</a></li>
            <li><a href="users.php">Manage Users</a></li>
            <li><a href="results.php">Results</a></li>
            <li><a href="merge.php" target="_blank">Videos</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </nav>
    <div class="container">
        <h1>View and Download Results</h1>
        
        <div class="body">
                
                
        </div>
        <h2>Quiz Results</h2>
    <table>
        <tr>
            <th>S/N</th>
            <th>User ID</th>
            <th> Candidate/School's Name</th>
            <?php foreach ($rounds as $round): ?>
                
                <th>Round <?php echo $round; ?> - %</th>
            <?php endforeach; ?>
        </tr>
        
        <?php $i =1; foreach ($scores as $user_id => $roundScores): ?>
        <tr>
            <td><?php echo $i++; ?></td>
            <td><?php echo $user_id; ?></td>
            
            <td><?php echo $schools[$user_id] ?? '-'; ?></td>
            <!-- <td><?= getUserOrSchoolName($user_id); ?></td> -->
            <?php foreach ($rounds as $round): ?>
                
                <td><?php echo $roundScores[$round]['percentage'] ?? '-'; ?></td>
            <?php endforeach; ?>
        </tr>
        <?php endforeach; ?>
    </table>

    <form method="GET">
        <button type="submit" name="download" class="download-btn">Download Excel</button>
    </form>
    </div>

</body>

</html>
