<?php
require '../db_connect.php';
// Check if admin is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ../home');
    exit();
}
if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], [1])) {
    msgAlert('You are not Allowed to view this Page!', '../home');
}
function getUserOrSchoolName($id){
    global $conn;
    
    $user = explode('/',$id);
    $user = $user[0];
    $sql = "SELECT * FROM `users` WHERE `user_id` = '$user'";
    $exec = mysqli_query($conn, $sql);
    $row = mysqli_fetch_assoc($exec);
    return empty($row['fullnames'])? $row['school_name']:$row['fullnames'];
}
function getChunkFolders($baseDir = '../home/uploads') {
    $userDirs = array_filter(glob("$baseDir/*"), 'is_dir');
    $videoFolders = [];

    foreach ($userDirs as $dir) {
        $videosPath = $dir . '/video';
        if (is_dir($videosPath)) {
            $videoFolders[] = basename($dir) . '/video'; // e.g., user1/videos
        }
    }

    return $videoFolders;
}

function mergeVideoChunks($chunksDir, $outputFile) {

    // $folder = realpath(__DIR__ . $chunksDir);
    $folder = realpath(__DIR__ . '/' . ltrim($chunksDir, '/'));


    if (!is_dir($folder)) return "Chunks directory does not exist.";
    $files = glob("$folder/*.webm");
    $files = array_filter($files, function($file) {
        return preg_match('/chunk_\d+\.webm$/', basename($file));
    });
    natsort($files);
    if (empty($files)) return "<span style='color:red'; >No video/.webm chunks found.</span>";

    // Remove existing output file if it already exists
    if (file_exists($outputFile)) {
        unlink($outputFile);
    }

    chdir($folder);
    // Build the concat string (only file names, not full paths)
    $chunkString = implode('|', array_map('basename', $files));
    
    $concatInput = 'concat:' . $chunkString;
    $cmd = "ffmpeg -i \"$concatInput\" -c copy \"$outputFile\"";
    exec($cmd, $output, $returnCode);
   // return $returnCode === 0 ? "✅ Merge success!" : "❌ Merge failed!";
   return $returnCode === 0 ? true : "Error merging video chunks:<br>" . implode("<br>", $output);
    
    

    // $cmd = "cd \"$folder\" && ffmpeg -f concat -safe 0 -i files.txt -c copy \"$outputFile\" 2>&1";
    // exec($cmd, $output, $returnCode);
    // //unlink($listFile);

    // return $returnCode === 0 ? true : "Error merging video chunks:<br>" . implode("<br>", $output);
}

$mergedFile = '';
$message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['main_folder'], $_POST['sub_folder'])) {
    $main = preg_replace('/[^a-zA-Z0-9\/_-]/', '',$_POST['main_folder']); // user1/videos

    $sub = basename($_POST['sub_folder']);   // session1
    $fullPath = "../home/uploads/$main/$sub";
    $outputName = "merged_" . str_replace(['/', '\\'], '_', "$main-$sub") . ".webm";
    $outputWebPath = "../home/uploads/$main/$sub/$outputName";
    // echo $fullPath;

    $result = mergeVideoChunks($fullPath, $outputName);
    $mergedFile = $result === true ? $outputWebPath : '';
    $message = $result === true ? "Merged successfully!" : $result;
}

$folders = getChunkFolders();
//print_r(getChunkFolders());
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Merge Video Chunks</title>
    <style>
        body {
            font-family: 'Segoe UI', sans-serif;
            background: #f2f2f2;
            margin: 0;
            padding: 40px;
            display: flex;
            justify-content: center;
            align-items: flex-start;
            min-height: 100vh;
        }

        .container {
            background: #fff;
            padding: 30px 40px;
            border-radius: 12px;
            box-shadow: 0 8px 20px rgba(0, 0, 0, 0.1);
            width: 600px;
            text-align: center;
        }

        h2 {
            color: #333;
            margin-bottom: 20px;
        }

        video {
            width: 50%;
            border-radius: 8px;
            margin-top: 20px;
            margin-bottom: 30px;
        }

        a.download-btn {
            display: inline-block;
            padding: 12px 24px;
            font-size: 16px;
            background: #007bff;
            color: #fff;
            border-radius: 6px;
            text-decoration: none;
            transition: background 0.3s ease;
        }

        a.download-btn:hover {
            background: #0056b3;
        }

        .success-message {
            color: #28a745;
            font-weight: 600;
            margin-bottom: 10px;
        }

        .form-group {
            margin-bottom: 25px;
            text-align: left;
        }

        label {
            font-weight: 600;
            margin-bottom: 8px;
            display: flex;
            flex-direction: column;
        }

        select, button {
            padding: 10px 15px;
            border: 1px solid #ccc;
            border-radius: 6px;
            font-size: 14px;
            width: 100%;
        }

        button {
            background: #28a745;
            color: white;
            font-weight: bold;
            cursor: pointer;
            margin-top: 10px;
        }

        button:hover {
            background: #218838;
        }

    </style>
    <script>
    function fetchSubfolders(folder) {
        const subSelect = document.getElementById('sub_folder');
        subSelect.innerHTML = '<option>Loading...</option>';
        fetch('requests/subfolders.php?folder=' + encodeURIComponent(folder))
            .then(res => res.json())
            .then(data => {
                //alert(data);
                subSelect.innerHTML = '';
                if (data.length === 0) {
                    subSelect.innerHTML = '<option>No subfolders found</option>';
                } else {
                    subSelect.innerHTML = '<option value="">-- Choose Subfolder --</option>';
                    data.forEach(name => {
                        let opt = document.createElement('option');
                        opt.value = name;
                        opt.innerText = name;
                        subSelect.appendChild(opt);
                    });
                }
                document.getElementById('subfolder_group').style.display = 'block';
            });
    }
    function refreshPage(){
        
        // Refresh the page after a short delay
        setTimeout(function() {
            location.href = 'merge.php';
        }, 1000); // 500ms delay before refresh (to allow download to start)
    }
    </script>
</head>
<body>
    <div class="container">
    <h2>Merge Video Chunks</h2>

    <form method="POST">
        <label for="main_folder">Select Main Folder:</label>
        <select name="main_folder" id="main_folder" required onchange="fetchSubfolders(this.value)">
            <option value="">-- Choose Folder --</option>
            <?php foreach ($folders as $folder): ?>
                <option value="<?= htmlspecialchars($folder) ?>"><?= getUserOrSchoolName(htmlspecialchars($folder)) ?></option>
            <?php endforeach; ?>
        </select>

        <div id="subfolder_group" style="display:none; margin-top:10px;">
            <label for="sub_folder">Select Subfolder:</label>
            <select name="sub_folder" id="sub_folder" required></select>
        </div>

        <br>
        <button type="submit">Merge</button>
    </form>

    <p style="color: green"><?= $message ?></p>

    <?php if ($mergedFile): ?>
        <h3>Preview:</h3>
        <video width="600" controls>
            <source src="<?= $mergedFile ?>" type="video/mp4">
        </video>
        <br><br>
        <a href="<?= $mergedFile ?>" download>
            <button style="padding: 10px 20px; font-size: 16px;" onclick="refreshPage()">Download Merged Video</button>
        </a>
    <?php endif; ?>
    </div>
</body>
</html>
