<?php
include('../db_connect.php'); // Database connection file

// Check if admin is logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: ../home');
    exit();
}
if (!isset($_SESSION['role']) || !in_array($_SESSION['role'], [1])) {
    msgAlert('You are not Allowed to view this Page!', '../home');
}

$query = "SELECT * FROM users WHERE role = 2 AND is_active = 1";
$result = mysqli_query($conn, $query);


?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Manage Questions - Quiz Admin</title>
    <!-- <script src="https://kit.fontawesome.com/a076d05399.js" crossorigin="anonymous"></script> -->
    <link rel="stylesheet" href="css/styles.css">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/css/select2.min.css" rel="stylesheet">
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- Select2 CSS -->

    <!-- Select2 JS -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.13/js/select2.min.js"></script>

    <style>
        .body {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 30vh;
            background-color: #f4f4f4;
            font-family: Arial, sans-serif;
            padding: 5px;
            /* margin-left:  20px; */
        }
        th {
            background: #f9f9f9;
        }

        .upload-container {
            display: flex;
            flex-direction: row;
            background: #fff;
            padding: 20px;
            margin-left: 20px;
            border-radius: 10px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.2);
            text-align: center;
            width: 430px;
        }

        .upload-container input[type="file"] {
            width: 90%;
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 5px;
            margin-bottom: 10px;
        }

        .filter-container {
            margin-bottom: 20px;
            text-align: left;
        }

        .filter-container select {
            padding: 8px;
            font-size: 16px;
        }

        .btn {
            background: #007bff;
            color: white;
            padding: 10px 15px;
            border: none;
            border-radius: 5px;
            cursor: pointer;
            font-size: 16px;
            width: 100%;
        }

        .btn:hover {
            background: #0056b3;
        }

        .link-primary {
            display: inline-block;
            margin-top: 10px;
            text-decoration: none;
            color: #007bff;
            font-weight: bold;
        }

        .link-primary:hover {
            text-decoration: underline;
        }
        /* Highlight correct answers */
        .correct {
            background-color: #28a745;
            color: white;
            font-weight: bold;
        }
        /* Candidate Form Container */
        #candidate-form {
            background: #f8f9fa; /* Light gray background */
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0px 4px 10px rgba(0, 0, 0, 0.1);
            max-width: 400px;
            margin-top: 20px;
        }

        /* Form Labels */
        #candidate-form label {
            display: block;
            font-weight: bold;
            margin-bottom: 5px;
            color: #333;
        }

        /* Input Fields */
        #candidate-form input {
            width: 90%;
            padding: 10px;
            margin-bottom: 15px;
            border: 1px solid #ccc;
            border-radius: 5px;
            font-size: 16px;
            transition: all 0.3s ease;
        }

        /* Input Fields - Focus Effect */
        #candidate-form input:focus {
            border-color: #007bff;
            outline: none;
            box-shadow: 0px 0px 5px rgba(0, 123, 255, 0.5);
        }

        /* Save Button */
        #save-btn {
            background: #007bff;
            color: white;
            border: none;
            padding: 10px;
            width: 100%;
            font-size: 16px;
            font-weight: bold;
            border-radius: 5px;
            cursor: pointer;
            transition: background 0.3s ease;
        }

        /* Save Button - Hover */
        #save-btn:hover {
            background: #0056b3;
        }

        /* Save Button - Disabled State */
        #save-btn:disabled {
            background: #aaa;
            cursor: not-allowed;
        }

        /* Message Box */
        #message-box {
            padding: 10px;
            margin-top: 10px;
            border-radius: 5px;
            display: none;
            font-weight: bold;
            text-align: center;
        }

        /* Loading Indicator */
        #loading {
            display: flex;
            align-items: center;
            justify-content: center;
            margin-top: 10px;
            font-weight: bold;
            color: #007bff;
        }

        /* Loading Spinner */
        #loading::before {
            content: "";
            width: 16px;
            height: 16px;
            border: 2px solid #007bff;
            border-top: 2px solid transparent;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        /* Spinner Animation */
        @keyframes spin {
            from { transform: rotate(0deg); }
            to { transform: rotate(360deg); }
        }

        /* Responsive Design */
        @media (max-width: 480px) {
            #candidate-form {
                max-width: 100%;
            }
        }

        /* Round Select Dropdown */
        #round, #no_question {
            width: 95%;
            padding: 12px;
            margin-bottom: 15px;
            border: 2px solid #007bff;
            border-radius: 8px;
            font-size: 16px;
            background: #f8f9fa;
            cursor: pointer;
            transition: all 0.3s ease-in-out;
        }

        /* Hover Effect */
        #round:hover, #no_question:hover {
            background: #e9ecef;
        }

        /* Focus Effect */
        #round:focus, #no_question:focus {
            border-color: #0056b3;
            outline: none;
            box-shadow: 0px 0px 8px rgba(0, 123, 255, 0.5);
        }

        /* Custom Arrow (for modern browsers) */
        #round, #no_question {
            appearance: none;
            -webkit-appearance: none;
            -moz-appearance: none;
            background-image: url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" width="20" height="20" viewBox="0 0 20 20"><polygon points="5,7 10,12 15,7" fill="%23007bff"/></svg>');
            background-repeat: no-repeat;
            background-position: right 10px center;
            background-size: 12px;
        }

        /* Disabled Select */
        #round:disabled, #no_question:disabled {
            background: #e9ecef;
            cursor: not-allowed;
            opacity: 0.6;
        }


    </style>
</head>
<body>
    <nav>
        <ul>
        <li><a href="index.php">Dashboard</a></li>
            <li><a href="questions.php">Manage Questions</a></li>
            <li><a href="exams.php">Manage Exams</a></li>
            <li><a href="users.php">Manage Users</a></li>
            <li><a href="results.php" target="_blank">Results</a></li>
            <li><a href="merge.php" target="_blank">Videos</a></li>
            <li><a href="logout.php">Logout</a></li>
        </ul>
    </nav>
    <div class="container">
        <h1>Manage Exam / Candidate</h1>
        
        <div class="body">
                
                <div class="upload-container">
                        <div class="filter-container">
                            <label for="round-filter">Candidate:</label>
                            <select id="round-filter" class="search-dropdown">
                                <option value="" selected>Select Candidate</option>
                                <?php while ($row = mysqli_fetch_assoc($result)) { ?>
                                    <option value="<?= htmlspecialchars($row['user_id']) ?>">
                                        <?= htmlspecialchars(empty($row['school_name']) ? $row['fullnames'] . ' (' . $row['user_id'] . ')' : $row['school_name'] . ' (' . $row['user_id'] . ')') ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>


                </div>
        </div>
        <!-- Candidate Details Form (Initially Hidden) -->
        <form id="candidate-form" style="display: none;">
            <input type="text" id="user_id" name="user_id" readonly>

            <label>Full Name:</label>
            <input type="text" id="fullnames" name="fullnames" readonly>

            <label>School Name:</label>
            <input type="text" id="school_name" name="school_name" readonly>

            <label for="round">Set Round:</label>
            <select id="round" name="round">
                <!-- Rounds will be loaded here via AJAX -->
            </select>

            <label for="no_question">Set No of Questions:</label>
            <select id="no_question" name="no_question">
                <!-- no_question will be loaded here via AJAX -->
            </select>

            <button type="button" id="save-btn">
                Save Changes
            </button>

            <p><strong>Total Available Questions:</strong> <span id="total-questions">0</span></p>
            <!-- Loading Indicator (Initially Hidden) -->
            <div id="loading" style="display: none; margin-top: 10px;">
                Saving...
            </div>
        </form>
    </div>

</body>
<script>
$(document).ready(function () {
    $('#no_question').hide();
    // When user selects a candidate
    $("#round-filter").change(function () {
        var userId = $(this).val();
        if (userId) {
            $("#candidate-form").hide(); // Hide form before loading
            $("#loading").show(); // Show loading indicator

            $.ajax({
                url: "requests/fetch_user_info.php",
                type: "POST",
                data: { user_id: userId },
                dataType: "json",
                success: function (response) {
                    $("#loading").hide(); // Hide loading indicator

                    if (response.status === "success") {
                        // Populate form fields
                        $("#user_id").val(response.data.user_id);
                        $("#fullnames").val((response.data.fullnames !== null)?response.data.fullnames:'N/A');
                        $("#school_name").val((response.data.school_name !== null)?response.data.school_name:'N/A');
                        $("#email").val(response.data.email);
                        $("#phone").val(response.data.phone);

                        // Load rounds and set the active one
                        loadRounds(response.data.round);

                        $("#candidate-form").show(); // Show form
                    } else {
                        alert("User not found.");
                    }
                }
            });
        } else {
            $("#candidate-form").hide(); // Hide form if no user selected
        }
    });


    // Function to Load Rounds from Database
    function loadRounds(selectedRound) {
        $.ajax({
            url: "requests/fetch_rounds.php",
            type: "GET",
            dataType: "json",
            success: function (rounds) {
                $("#round").empty(); // Clear existing options
                //console.log(rounds)
                $("#round").append('<option value="" selected disabled>Select Round</option>');
                rounds.forEach(function (round) {
                    // var selected = (round.id == selectedRound) ? "selected" : "";
                    // $("#round").append('<option value="' + round.id + '" ' + selected + '>' + round.rname + '</option>');
                    $("#round").append('<option value="' + round.id + '">' + round.rname + '</option>');
                });
            }
        });
    }

    // Load total number of questions when a round is selected
    $("#round").change(function () {
        var roundId = $(this).val();

        if (roundId) {
            $("#total-questions").text("Loading..."); // Show loading indicator

            $.ajax({
                url: "requests/fetch_question_count.php",
                type: "POST",
                data: { round_id: roundId },
                dataType: "json",
                success: function (response) {
                    $("#no_question").empty(); // Clear existing options
                    if (response.status === "success") {
                        $('#no_question').show();
                        $("#total-questions").text(response.total);
                        let highestNumber = response.total;
                        for (let index = 1; index <= highestNumber; index++) {
                            $("#no_question").append('<option value="' + index + '">' + index + '</option>');
                            
                        }
                        
                       
                    } else {
                        $("#total-questions").text("0");
                    }
                }
            });
        } else {
            $("#total-questions").text("0");
        }
    });


    // Save Edited Candidate Details
    $("#save-btn").click(function () {
        $("#save-btn").prop("disabled", true); // Disable button
        $("#loading").show(); // Show "Saving..." indicator
        let formData = $("#candidate-form").serialize();
        //console.log(formData)
        
        $.ajax({
            url: "requests/update_candidate.php",
            type: "POST",
            data: formData,
            success: function (response) {
                $("#loading").hide(); // Hide "Saving..." indicator
                $("#save-btn").prop("disabled", false); // Re-enable button

                alert(response); // Show success message
            }
        });
    });

    $(".search-dropdown").select2({
        placeholder: "Select a round",
        allowClear: true
    });

});
</script>
</html>
