<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Webcam Check</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f2f2f2;
      text-align: center;
      padding-top: 100px;
    }
    .message {
      font-size: 24px;
      color: #333;
    }
  </style>
</head>
<body>

  <div id="status" class="message">Checking webcam access...</div>

  <script>
    async function checkWebcam() {
      try {
        const stream = await navigator.mediaDevices.getUserMedia({ video: true });
        
        // If successful, stop the stream and redirect
        stream.getTracks().forEach(track => track.stop());

        // Redirect to your target URL
        window.location.href = "../";
      } catch (err) {
        // Webcam not allowed or failed
        document.getElementById("status").textContent = "Webcam access is disabled. Please allow access to continue.";
      }
    }

    checkWebcam();
  </script>

</body>
</html>
